using ConnectorLib.JSON;
using Inventory;

namespace CrowdControl.Delegates.Effects.Implementations
{
    [Effect("give_scarletSword", "give_crackedPetEgg", "give_petEgg", "give_tome", "give_galaxiteChakram", "give_runeSong", "give_cosmosArmour", "give_hazmatArmour")]
    public class AddInventory : Effect
    {
        public AddInventory(CrowdControl mod, NetworkClient client) : base(mod, client) { }
        
        public override EffectResponse Start(EffectRequest request)
        {
            PlayerController player = Manager.main.player;
            if (player == null) 
                return EffectResponse.Failure(request.ID, StandardErrors.PlayerNotFound);

            string[] codeParams = request.code.Split('_');
            if (codeParams.Length < 2)
                return EffectResponse.Failure(request.ID, StandardErrors.BadRequest, "Invalid effect code format.");

            InventoryHandler inventory = player.playerInventoryHandler;
            if (inventory == null)
                return EffectResponse.Failure(request.ID, StandardErrors.PlayerNotFound, "Player inventory not found.");

            bool freeSlots = false;
            int invMax = inventory.maxSize;
            int i = 0;
            for (; i < invMax; i++)
            {
                ContainedObjectsBuffer items = inventory.GetContainedObjectData(i);
                if (items.objectID == ObjectID.None)
                {
                    freeSlots = true;
                    break;
                }
            }
            
            if(!freeSlots)
                return EffectResponse.Failure(request.ID, StandardErrors.NoEmptyContainers, "No free inventory slots available.");

            switch (codeParams[1])
            {
                case "scarletSword":
                    CreateItem(inventory, i, ObjectID.ScarletSword);
                    break;
                case "crackedPetEgg":
                    CreateItem(inventory, i, ObjectID.PetCatEggCracked);
                    break;
                case "petEgg":
                    CreateItem(inventory, i, ObjectID.PetCatEgg);
                    break;
                case "tome":
                    CreateItem(inventory, i, ObjectID.TomeOfFire);
                    break;
                case "galaxiteChakram":
                    CreateItem(inventory, i, ObjectID.GalaxiteChakram);
                    break;
                case "runeSong":
                    CreateItem(inventory, i, ObjectID.RuneSongTrail);
                    break;
                case "cosmosArmour":
                    CreateItem(inventory, i, ObjectID.CrystalBreastArmor);
                    break;
                case "hazmatArmour":
                    CreateItem(inventory, i, ObjectID.SulfurBreastArmor);
                    break;
                default:
                    return EffectResponse.Failure(request.ID, StandardErrors.BadRequest, "Unknown item code.");
            }

            return EffectResponse.Success(request.ID);
        }
        
        private static void CreateItem(InventoryHandler inventory, int slotIndex, ObjectID newItemID)
        {
            Manager.main.player.QueueInputAction(new()
            {
                action = UIInputAction.InventoryChange,
                inventoryChangeData = Create.CreateItem(
                    inventory.inventoryEntity,
                    slotIndex,
                    newItemID,
                    1,
                    EntityMonoBehaviour.ToWorldFromRender(inventory.entityMonoBehaviour.RenderPosition),
                    0)
            });
        }
    }
}